#ifdef WIN32
#pragma once

#pragma warning(push)
#pragma warning(disable:4800)
#include "apcom/apcom.h"
#pragma warning(pop)

#include "IConnectFactory.h"

namespace CSFUnified
{
	namespace MeetingStackCap
	{
		template <class M, class E>
		class CHelper 
		{	
		private:
			CConComPtr<M> manager;
			unsigned int cookie;
			CUnknown<E>* sink;

		public:
			CHelper(CUnknown<E>* aSink)
			{
				this->sink = aSink;
				manager = NULL;
				conHRESULT hr = IConnectFactory::GetInstance()->QueryInterface(__conuuidof(M), (void**)&manager);

				if (CONSUCCEEDED(hr) && manager != NULL)
				{
					sink->AddRef();
					cookie = 0;
					APAdvise(manager, sink, __conuuidof(E), &cookie);
				}
				else
				{
					throw std::logic_error("Unable to initialize IMP"); 
				}
			}

			~CHelper()
			{
				if (manager)
				{
					APUnAdvise(manager,  __conuuidof(E) , cookie) ;
					cookie = 0 ;
					//This step is necessary to release the manager so it can be destructed,
					//unfortunately it not done consistently within the stack but we do it
					//to not make things worse
					manager.Release();
				}
			}

			CConComPtr<M> getManager()
			{
				return manager;
			}
		};

		template <class M, class E>
		class ComponentManager : public CUnknown<E>
		{
		public:
			ComponentManager():m_pHelper(NULL)
			{
				start();
			}

			~ComponentManager()
			{
				stop();
			}

			void start()
			{
				//helper.reset(new ComponentHelper(this));
				if (NULL == m_pHelper)
				{
					m_pHelper = new ComponentHelper(this);
				}
			}

			void stop()
			{
				//helper.reset();
				if (NULL != m_pHelper)
				{
					delete m_pHelper;
					m_pHelper = NULL;
				}
			}

			CConComPtr<M> getManager()
			{
				return m_pHelper->getManager();
			}

			conIClassFactory* ModuleGetClassFactory()
			{
				return IConnectFactory::GetInstance();
			}

		private:
			typedef CHelper<M,E> ComponentHelper;
			//auto_ptr<ComponentHelper> helper;
			ComponentHelper* m_pHelper;
		};
	}
}

#endif